package gov.va.med.mhv.portal.nsoc;

import gov.va.med.mhv.portal.nsoc.redirect.NsocDao;
import gov.va.med.mhv.portal.nsoc.redirect.RedirectUrl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class RedirectUrlServlet extends HttpServlet {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private static WebApplicationContext webAppContext;
	private static RequestDispatcher dispatcher;
	
	@Override
	public void init() throws ServletException {
		super.init();
		webAppContext = WebApplicationContextUtils.getWebApplicationContext(getServletContext());
		dispatcher = this.getServletContext().getRequestDispatcher("/exit_script.jsp");
	}
	
	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		
		String url = request.getQueryString();
		NsocDao dao = (NsocDao) webAppContext.getBean("nsocDao");
		RedirectUrl redirectUrl = dao.getRedirectUrlByUrl(url);
		if(redirectUrl.isValid()){
	    	response.sendRedirect(url);
		}else{
			request.setAttribute("forward_url", url);
			request.setAttribute("error_message", redirectUrl.getErrorMessage());
	    	dispatcher.forward(request, response);	
		}
	}

	@Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		doGet(request, response);
	}

}
